/*
 * Decompiled with CFR 0.152.
 */
package com.starmicronics.utility.POSPrinter.Star;

import com.starmicronics.utility.BaseTextMagnification;
import com.starmicronics.utility.POSPrinter.Star.PrinterFontStar;
import com.starmicronics.utility.ParsedJposEntry;
import com.starmicronics.utility.PrintResolution;
import java.util.ArrayList;
import java.util.Collections;
import java.util.TreeSet;
import jpos.JposException;

public class PrinterFontStarThermal
extends PrinterFontStar {
    public static final int LINE_SPACING_STANDARD_NARROW = 24;
    public static final int LINE_SPACING_STANDARD_WIDE = 32;
    public static final int LINE_SPACING_X1_5_NARROW = 36;
    public static final int LINE_SPACING_X1_5_WIDE = 48;
    public static final int LINE_HEIGHT_STANDARD = 24;
    public static final int LINE_HEIGHT_X1_5 = 36;
    private static final int COMMAND_PARAM_FONTA = 0;
    private static final int COMMAND_PARAM_FONTB = 1;
    private int m_dotLineSpacing;
    private int m_dotLineSpacingWide;
    private int m_dotLineSpacingNarrow;
    private int m_lineCharsFontASpace6;
    private int m_lineCharsFontASpace5;
    private int m_lineCharsFontASpace4;
    private int m_lineCharsFontASpace3;
    private int m_lineCharsFontASpace2;
    private int m_lineCharsFontASpace1;
    private int m_lineCharsFontASpace0;
    private int m_lineCharsFontBSpace2;
    private int m_lineCharsFontBSpace1;
    private int m_lineCharsFontBSpace0;
    private boolean m_isExpandedSpace;
    private PrintResolution m_printResolution = PrintResolution.ResolutionNotSpecified;
    private BaseTextMagnification m_baseTextMagnification = BaseTextMagnification.NotSupported;

    public PrinterFontStarThermal(int n, boolean bl, ParsedJposEntry parsedJposEntry) {
        super(n, bl);
        this.m_printResolution = parsedJposEntry.getPrintResolution();
        this.m_baseTextMagnification = parsedJposEntry.getBaseTextMagnification();
        block0 : switch (this.m_printResolution) {
            case Resolution300dpi: {
                switch (this.m_baseTextMagnification) {
                    case X1_5: {
                        this.m_dotLineSpacingWide = 48;
                        this.m_dotLineSpacingNarrow = 36;
                        break block0;
                    }
                }
                this.m_dotLineSpacingWide = 32;
                this.m_dotLineSpacingNarrow = 24;
                break;
            }
            default: {
                this.m_dotLineSpacingWide = 32;
                this.m_dotLineSpacingNarrow = 24;
            }
        }
        this.m_dotLineSpacing = this.m_dotLineSpacingWide;
        if (PrinterFontStarThermal.is300dpiAndX1_5(this.m_printResolution, this.m_baseTextMagnification)) {
            this.m_lineCharsFontASpace6 = n / 27;
            this.m_lineCharsFontASpace5 = n / 25;
            this.m_lineCharsFontASpace4 = n / 24;
            this.m_lineCharsFontASpace3 = n / 22;
            this.m_lineCharsFontASpace2 = n / 21;
            this.m_lineCharsFontASpace1 = n / 19;
            this.m_lineCharsFontASpace0 = n / 18;
            this.m_lineCharsFontBSpace2 = n / 17;
            this.m_lineCharsFontBSpace1 = n / 15;
            this.m_lineCharsFontBSpace0 = n / 14;
        } else {
            this.m_lineCharsFontASpace6 = n / 18;
            this.m_lineCharsFontASpace5 = n / 17;
            this.m_lineCharsFontASpace4 = n / 16;
            this.m_lineCharsFontASpace3 = n / 15;
            this.m_lineCharsFontASpace2 = n / 14;
            this.m_lineCharsFontASpace1 = n / 13;
            this.m_lineCharsFontASpace0 = n / 12;
            this.m_lineCharsFontBSpace2 = n / 11;
            this.m_lineCharsFontBSpace1 = n / 10;
            this.m_lineCharsFontBSpace0 = n / 9;
        }
        this.m_lineChars = this.m_lineCharsFontASpace0;
        this.m_isExpandedSpace = n == 832;
    }

    @Override
    public void setLineChars(int n) throws JposException {
        if (this.m_isExpandedSpace && n <= this.m_lineCharsFontASpace6) {
            this.m_lineChars = this.m_lineCharsFontASpace6;
        } else if (this.m_isExpandedSpace && n <= this.m_lineCharsFontASpace5) {
            this.m_lineChars = this.m_lineCharsFontASpace5;
        } else if (n <= this.m_lineCharsFontASpace4) {
            this.m_lineChars = this.m_lineCharsFontASpace4;
        } else if (n <= this.m_lineCharsFontASpace3) {
            this.m_lineChars = this.m_lineCharsFontASpace3;
        } else if (n <= this.m_lineCharsFontASpace2) {
            this.m_lineChars = this.m_lineCharsFontASpace2;
        } else if (n <= this.m_lineCharsFontASpace1) {
            this.m_lineChars = this.m_lineCharsFontASpace1;
        } else if (n <= this.m_lineCharsFontASpace0) {
            this.m_lineChars = this.m_lineCharsFontASpace0;
        } else if (this.getCapFontB() && n <= this.m_lineCharsFontBSpace2) {
            this.m_lineChars = this.m_lineCharsFontBSpace2;
        } else if (this.getCapFontB() && n <= this.m_lineCharsFontBSpace1) {
            this.m_lineChars = this.m_lineCharsFontBSpace1;
        } else if (this.getCapFontB() && n <= this.m_lineCharsFontBSpace0) {
            this.m_lineChars = this.m_lineCharsFontBSpace0;
        } else {
            throw new JposException(106, "This request is illegal because the specified number of line characters exceeds the maximum number possible.");
        }
    }

    @Override
    public String getLineCharsList() {
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        if (this.m_isExpandedSpace) {
            treeSet.add(this.m_lineCharsFontASpace6);
            treeSet.add(this.m_lineCharsFontASpace5);
        }
        treeSet.add(this.m_lineCharsFontASpace4);
        treeSet.add(this.m_lineCharsFontASpace3);
        treeSet.add(this.m_lineCharsFontASpace2);
        treeSet.add(this.m_lineCharsFontASpace1);
        treeSet.add(this.m_lineCharsFontASpace0);
        if (this.getCapFontB()) {
            treeSet.add(this.m_lineCharsFontBSpace2);
            treeSet.add(this.m_lineCharsFontBSpace1);
            treeSet.add(this.m_lineCharsFontBSpace0);
        }
        ArrayList arrayList = new ArrayList(treeSet);
        Collections.sort(arrayList);
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < arrayList.size(); ++i) {
            if (i != 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(arrayList.get(i));
        }
        return stringBuilder.toString();
    }

    @Override
    public int getDotLineSpacing() {
        return this.m_dotLineSpacing;
    }

    @Override
    public void setDotLineSpacing(int n) throws JposException {
        this.m_dotLineSpacing = this.m_dotLineSpacingNarrow >= n ? this.m_dotLineSpacingNarrow : this.m_dotLineSpacingWide;
    }

    @Override
    public int getRecLinesToPaperCut() {
        return 120 / this.m_dotLineSpacing;
    }

    @Override
    public byte getFontSelect() {
        if (!this.getCapFontB()) {
            return 0;
        }
        if (this.m_isExpandedSpace && this.m_lineChars == this.m_lineCharsFontASpace6 || this.m_isExpandedSpace && this.m_lineChars == this.m_lineCharsFontASpace5) {
            return 0;
        }
        if (this.m_lineChars == this.m_lineCharsFontASpace4 || this.m_lineChars == this.m_lineCharsFontASpace3 || this.m_lineChars == this.m_lineCharsFontASpace2 || this.m_lineChars == this.m_lineCharsFontASpace1 || this.m_lineChars == this.m_lineCharsFontASpace0) {
            return 0;
        }
        if (this.m_lineChars == this.m_lineCharsFontBSpace2 || this.m_lineChars == this.m_lineCharsFontBSpace1 || this.m_lineChars == this.m_lineCharsFontBSpace0) {
            return 1;
        }
        return 0;
    }

    @Override
    public byte getRightSideCharacterSpacing() {
        if (this.m_isExpandedSpace && this.m_lineChars == this.m_lineCharsFontASpace6) {
            return 6;
        }
        if (this.m_isExpandedSpace && this.m_lineChars == this.m_lineCharsFontASpace5) {
            return 5;
        }
        if (this.m_lineChars == this.m_lineCharsFontASpace4) {
            return 4;
        }
        if (this.m_lineChars == this.m_lineCharsFontASpace3) {
            return 3;
        }
        if (this.m_lineChars == this.m_lineCharsFontASpace2) {
            return 2;
        }
        if (this.m_lineChars == this.m_lineCharsFontASpace1) {
            return 1;
        }
        if (this.m_lineChars == this.m_lineCharsFontASpace0) {
            return 0;
        }
        if (this.getCapFontB() && this.m_lineChars == this.m_lineCharsFontBSpace2) {
            return 2;
        }
        if (this.getCapFontB() && this.m_lineChars == this.m_lineCharsFontBSpace1) {
            return 1;
        }
        if (this.getCapFontB() && this.m_lineChars == this.m_lineCharsFontBSpace0) {
            return 0;
        }
        return 0;
    }

    public static boolean is300dpiAndX1_5(PrintResolution printResolution, BaseTextMagnification baseTextMagnification) {
        boolean bl = false;
        block0 : switch (printResolution) {
            case Resolution300dpi: {
                switch (baseTextMagnification) {
                    case X1_5: {
                        bl = true;
                        break block0;
                    }
                }
                break;
            }
        }
        return bl;
    }

    @Override
    public int getDotLineSpacingWide() {
        return this.m_dotLineSpacingWide;
    }

    @Override
    public int getDotLineSpacingNarrow() {
        return this.m_dotLineSpacingNarrow;
    }

    @Override
    public BaseTextMagnification getBaseTextMagnification() {
        return this.m_baseTextMagnification;
    }
}

